/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.messaging;

import de.willuhn.io.FileWatch;
import de.willuhn.jameica.messaging.FileChangedMessage;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.SystemMessage;
import de.willuhn.jameica.system.Application;
import java.io.File;
import java.util.Observable;
import java.util.Observer;

public class FileChangedMessageConsumer
implements MessageConsumer,
Observer {
    @Override
    public boolean autoRegister() {
        return true;
    }

    @Override
    public Class[] getExpectedMessageTypes() {
        return new Class[]{SystemMessage.class};
    }

    @Override
    public void handleMessage(Message message) throws Exception {
        if (message == null) {
            return;
        }
        SystemMessage m = (SystemMessage)message;
        if (m.getStatusCode() != 1) {
            return;
        }
        File[] files = Application.getClassLoader().getFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].exists()) continue;
            FileWatch.addFile((File)files[i], (Observer)this);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null || !(arg instanceof File)) {
            return;
        }
        Application.getMessagingFactory().sendMessage(new FileChangedMessage((File)arg));
    }
}

